package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;

public class ObjectSelectPaletteObject extends PaletteObject {

	@Override
	public void draw(Graphics g) {
		
		if(image == null || clickRect == null) {
			return;
		}
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
		
	}
	
	
	public ObjectSelectPaletteObject(IntRect theClickRect, int theDistanceToBorder, int theBorderWidth, RoomEditorPanel thePanel, CustomImageDataII theImage) {
		
		clickRect = theClickRect;
		isSelected = false;
		editorPanel = thePanel;
		
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		
		image = theImage;
		
	}
	
	public void setSelected(boolean is) {
		isSelected = is;
	}
	
}
